// import baseURL from '../common/config.js'

// 请求服务器地址
// const baseURL = 'http://192.168.50.242:8026';
// 向外暴露一个方法 myRequest
export const myRequest = (options) => {
  let headers = {};
  // headers["Content-Type"] = "multipart/form-data";
  headers['Content-Type'] = 'application/json';
  // headers["Content-Type"] = "application/x-www-form-urlencoded";

  return new Promise((resolve, reject) => {
    uni.request({
      // 开发者服务器接口地址（请求服务器地址 + 具体接口名）
      url: options.url,
      // 请求方式（若不传，则默认为 GET ）
      method: options.method || 'GET',
      // 请求参数（若不传，则默认为 {} ）
      data: { ...(options.data || {}) },
      header: headers,
      // 请求成功
      success: (res) => {
        // 此判断可根据自己需要更改
        if (res.statusCode == 500) {
          reject(res);
          return uni.showToast({
            title: '网络错误！',
            icon: 'none',
          });
        }
        resolve(res);
      },
      // 请求失败
      fail: (err) => {
        uni.showToast({
          title: '请求接口失败！',
          icon: 'none',
        });
        reject(err);
      },
      //请求结束之后，执行的回调函数（成功或失败都会执行）
      complete() {
        //隐藏loading
        // uni.hideLoading()
      },
    });
  });
};

export default myRequest;
