// 此vm参数为页面的实例，可以通过它引用vuex中的变量
module.exports = (vm) => {
  // 初始化请求配置
  uni.$u.http.setConfig((config) => {
    return config;
  });

  // 请求拦截
  uni.$u.http.interceptors.request.use(
    (config) => {
      config.data = config.data || {};

      // config.header.token = '1234qwer1234';
      config.params.token = '1234qwer1234';
      return config;
    },
    (config) => {
      return Promise.reject(config);
    }
  );

  // 响应拦截
  uni.$u.http.interceptors.response.use(
    (response) => {
      const data = response.data;

      if (data.errcode) {
        if (data.errcode === 302) {
          uni.$u.toast(data.msg);
          window.location.href = data.data.location;
          return Promise.reject(response);
        }
        uni.$u.toast(data.msg);
        return Promise.reject(response);
      }
      return data.data === undefined ? {} : data.data;
    },
    (response) => {
      // 对响应错误做点什么 （statusCode !== 200）
      return Promise.reject(response);
    }
  );
};
