// import baseURL from '../common/config.js'

// 请求服务器地址
// const baseURL = 'http://192.168.50.242:8026';
// 向外暴露一个方法 myRequest
export const myRequest = (options) => {
  let headers = {};
  // headers["Content-Type"] = "multipart/form-data";
  headers['Content-Type'] = 'application/json';
  // headers["Content-Type"] = "application/x-www-form-urlencoded";

  return new Promise((resolve, reject) => {
    uni.request({
      // 开发者服务器接口地址（请求服务器地址 + 具体接口名）
      url: options.url,
      // 请求方式（若不传，则默认为 GET ）
      method: options.method || 'GET',
      // 请求参数（若不传，则默认为 {} ）
      data: { ...(options.data || {}) },
      header: headers,
      // 请求成功
      success: (res) => {
        // 此判断可根据自己需要更改
        if (res.statusCode == 500) {
          reject(res);
          return uni.showToast({
            title: '网络错误！',
            icon: 'none',
          });
        }
        resolve(res);
      },
      // 请求失败
      fail: (err) => {
        uni.showToast({
          title: '请求接口失败！',
          icon: 'none',
        });
        reject(err);
      },
      //请求结束之后，执行的回调函数（成功或失败都会执行）
      complete() {
        //隐藏loading
        // uni.hideLoading()
      },
    });
  });
};

export const getPrice = (value = 0) => Number(value ?? 0) / 100;

// 图片水印
const base64_encode = (str) => {
  // 下面是64个基本的编码
  const base64EncodeChars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  let out;
  let i;
  let len;
  let c1;
  let c2;
  let c3;
  len = str.length;
  i = 0;
  out = '';
  while (i < len) {
    c1 = str.charCodeAt(i++) & 0xff;
    if (i == len) {
      out += base64EncodeChars.charAt(c1 >> 2);
      out += base64EncodeChars.charAt((c1 & 0x3) << 4);
      out += '==';
      break;
    }
    c2 = str.charCodeAt(i++);
    if (i == len) {
      out += base64EncodeChars.charAt(c1 >> 2);
      out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
      out += base64EncodeChars.charAt((c2 & 0xf) << 2);
      out += '=';
      break;
    }
    c3 = str.charCodeAt(i++);
    out += base64EncodeChars.charAt(c1 >> 2);
    out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
    out += base64EncodeChars.charAt(((c2 & 0xf) << 2) | ((c3 & 0xc0) >> 6));
    out += base64EncodeChars.charAt(c3 & 0x3f);
  }
  return out;
};

const utf16to8 = (str) => {
  let out;
  let i;
  let len;
  let c;
  out = '';
  len = str.length;
  for (i = 0; i < len; i++) {
    c = str.charCodeAt(i);
    if (c >= 0x0001 && c <= 0x007f) {
      out += str.charAt(i);
    } else if (c > 0x07ff) {
      out += String.fromCharCode(0xe0 | ((c >> 12) & 0x0f));
      out += String.fromCharCode(0x80 | ((c >> 6) & 0x3f));
      out += String.fromCharCode(0x80 | ((c >> 0) & 0x3f));
    } else {
      out += String.fromCharCode(0xc0 | ((c >> 6) & 0x1f));
      out += String.fromCharCode(0x80 | ((c >> 0) & 0x3f));
    }
  }
  return out;
};

export const baseEncode = (str) => {
  return base64_encode(utf16to8(str));
};

export default myRequest;
