// 此vm参数为页面的实例，可以通过它引用vuex中的变量
module.exports = (vm) => {
  // 初始化请求配置
  uni.$u.http.setConfig((config) => {
    return config;
  });

  // 请求拦截
  uni.$u.http.interceptors.request.use(
    (config) => {
      config.data = config.data || {};

      config.params.token = 'd957a00e9a9834b7fda7578f334cb67e';
      return config;
    },
    (config) => {
      return Promise.reject(config);
    }
  );

  // 响应拦截
  uni.$u.http.interceptors.response.use(
    (response) => {
      const data = response.data;

      if (data.errcode) {
        if (data.errcode === 302) {
          uni.$u.toast(data.msg);
          window.location.href = data.data.location;
          return Promise.reject(response);
        }
        uni.$u.toast(data.msg);
        return Promise.reject(response);
      }
      return data.data === undefined ? {} : data.data;
    },
    (response) => {
      // 对响应错误做点什么 （statusCode !== 200）
      return Promise.reject(response);
    }
  );
};
